;; INTERPERSONAL CHANNELS AND INNOVATION DIFFUSION - FIRST VERSION 11.06.2015
;; this model catch the opinion formation among economic agents toward an incremental innovation as influenced by the social interplay with other agents
;; agents are persuaded to adopt if their opinion is positive and exceeds a certin treshold
;; the main drivers of persuation are the opinion of the other agents the subject interact with
;; the model reproduce the web of relations among a real local productive system of agricultural firms 
;; the model is calibrated to obtain a percentage of adopters similar to the one observed in real data
;; the aim is to model policy actions able to make more speedy and effcient the innovation spread (in terms of positive opinion formation)

turtles-own 
[node-id ;;this is tha name of each turtle
  persuation ;; this indicates the level of persuation of each actors
  threshold ;; this is the minimun proportion of the agent neighbor necessary to persuade the agent towards the novelty
  opinion ;; this is the agent's level of acceptance towards the novelty
  edu ;; this is the agent's level of education
  novelty? ;; this is a boolean: false if the persuation is lower than the threshold and true if the persuation is equal or greather than the threshold ]
  influence ;; this is the influence exerted by neighbors on the agent as calculated with the procedure to pass-information
  susceptible? ;; this is a boolean: false if the agent is not suceptible to neighbor influence (its persuation does not variate during the process
               ;; true if the agent is suceptible to neighbor influence (its persuation variates during the process)
  n-strenght ;; is the amount of persuation exerted by the neighbors on the agent              
  injection ;; this is 1 if the agents is used as and injection point and o otherwise
  out-pressure ;; the pressure the agent exert on the others
  out-pressure2 ;; the pressure the agent exert on the others proof 
  in-link
  out-link
]

links-own [strenght]

globals [links-list]

to setup
  clear-all
  set-default-shape turtles "circle"
  import-attributes
  layout-circle (sort turtles) (max-pxcor - 1)
  import-links
  select-agent
  reset-ticks
  
end

;; This procedure reads in a files that contains node-specific attributes
;; including an unique identification number
to import-attributes
  ;; This opens the file, so we can use it.
  file-open "ATTRIBUTES_50.txt"
  ;; Read in all the data in the file
  ;; data on the line is in this order:
  ;; node-id attribute1 attribute2
  while [not file-at-end?]
  [
    ;; this reads a single line into a three-item list
    let items read-from-string (word "[" file-read-line "]")
    crt 1 [
      set node-id item 0 items
      set injection 0 ;; item 1 items
      set threshold item 2 items  
      set opinion item 3 items  
      set edu item 4 items  
      set color green
      set novelty? false
      set influence 0
      set susceptible? true
      set n-strenght 0
      set persuation 0
      set out-pressure 0
      set in-link []
      set out-link []       
      ]
   ]
  file-close
end

to select-agent
  ask turtle me [
    set injection 1
    set susceptible? false
    set persuation 1
    set novelty? true
    set color red] 
end

;; The following procedure (between **START** and **END**) is replicated from 
;; Network Import Example, by Uri Wilensky (model ID 2214) -- NetLogo 
;; link: http://modelingcommons.org/browse/one_model/2214#model_tabs_browse_procedures
;; **START**
;; This procedure reads in a file that contains all the links
;; The file is simply 3 columns separated by spaces.  In this
;; example, the links are directed.  The first column contains
;; the node-id of the node originating the link.  The second
;; column the node-id of the node on the other end of the link.
;; The third column is the strength of the link.

to import-links
  ;; This opens the file, so we can use it.
  file-open "KN_COOP_HOMOPHILY_50.txt"
  ;; Read in all the data in the file
  while [not file-at-end?]
  [
    ;; this reads a single line into a three-item list
    let items read-from-string (word "[" file-read-line "]")
    ask get-node (item 0 items)
    [
      create-link-to get-node (item 1 items)
        [ set strenght item 2 items ]
    ]
  ]
  file-close
end
;; **END**
   
to pass-information
ask patches [
  let Rsk random-float 0.5
    ifelse random-float 1 > Rsk
      [set pcolor gray - 3 ] ;; randomly distribute Risk  - gray means that half revenues are achieved by niche producers
      [set pcolor black ]     
  ]
ask turtles [
    if pcolor = gray - 3
    [
      if susceptible? = true
      [
  let neighbors-persuation (map [[persuation] of ?] sort in-link-neighbors) ;; the list of persuation of my ORDERED neighbors
  let links-strenght (map [[strenght] of ?] sort my-in-links)  ;; the list of my ORDERED in-links strenght
  let neighbors-number count in-link-neighbors
  let neighbors-strenght (map * neighbors-persuation links-strenght)
  set n-strenght sum neighbors-strenght
  if neighbors-number > 0
[  set influence n-strenght / neighbors-number
   if influence > 1 [set influence 1]]
set persuation (persuation + influence) * edu / 21.5 ;; edu / 21 is the factor that catchs the effect of agent's educatnio on the complex of information passed by his neighbors
 if persuation > 1 [set persuation 1]     


if disappoint [ 
 let Rsk random-float 0.5
 let var (14 + random 14)
 if ticks = var [
 if random-float 1 > Rsk [
 let var1 (random 1 + random 3)
 let var2 (random-float -0.5 + random-float 0.5)
 ask n-of var1 turtles [set persuation var2] 
 ]
 ]
  ]
      ]
    ]
] 
end
  
to persuade
  
  if ticks mod 4 = 0 [
  ask turtles [
  ifelse persuation >= threshold 
     [set novelty? true]
     [set novelty? false]
     ifelse novelty? = true
     [set color red
         ]
     [set color green]
     let out-links-strenght (map [[strenght] of ?] sort my-out-links)  ;; the list of my ORDERED out-links strenght
     let my-strenght (map [? * persuation] out-links-strenght)
     set out-pressure sum my-strenght 
         
     let out-links-strenght2 [strenght] of my-in-links  ;;  the list of my out-links strenght
     let my-strenght2 (map [? * persuation] out-links-strenght2)
     set out-pressure2 sum my-strenght2 
  ]
   ] 
end  
 
 
 to-report get-node [id]
  report one-of turtles with [node-id = id]
 end
 
 to go
   pass-information
   persuade
   set-current-plot "Agent Persuaded"
   plot agent-persuaded2
   tick
end
 
to-report agent-persuaded
  report count turtles with [novelty? = true]
end

to-report agent-persuaded2
  report count turtles with [color = red]
end

to-report average-strenght
  report mean [n-strenght] of turtles
end

to-report average-influence
  report mean [influence] of turtles
end

to-report average-persuation
  report mean [persuation] of turtles
end

to-report persuaded 
 report map [[novelty?] of ? ] sort turtles 
end

to-report pressure 
  report map [[n-strenght] of ?] sort turtles 
end

to-report attitude
  report map [[persuation] of ?] sort turtles 
end

to-report my-pressure
 report map [[out-pressure] of ?] sort turtles
end

to-report my-pressure2
 report map [[out-pressure2] of ?] sort turtles
end
@#$#@#$#@
GRAPHICS-WINDOW
184
10
614
461
17
17
12.0
1
12
1
1
1
0
0
0
1
-17
17
-17
17
0
0
1
ticks
30.0

BUTTON
30
46
166
79
NIL
setup
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
34
140
97
173
NIL
go
T
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

MONITOR
29
199
152
244
count-persuaded
agent-persuaded
5
1
11

MONITOR
29
256
140
301
average-strenght
average-strenght
5
1
11

MONITOR
28
314
141
359
average-influence
average-influence
5
1
11

MONITOR
28
367
151
412
average-persuation
average-persuation
5
1
11

PLOT
756
53
956
203
Agent Persuaded
NIL
NIL
0.0
10.0
0.0
10.0
true
false
"" ""
PENS
"default" 1.0 0 -16777216 true "" "plot count turtles with [novelty? = true]"

SWITCH
33
420
145
453
disappoint
disappoint
1
1
-1000

INPUTBOX
719
252
940
312
me
1
1
0
Number

@#$#@#$#@
## WHAT IS IT?

The code example provides an illustration of how to import network data from external files.  This is useful when you have a specific network, perhaps created in another program or taken from real world data, that you would like to recreate in NetLogo.

It imports data from two different files.  The first is the "attributes.txt" file, which contains information about the nodes -- in this case, the node-id, size, and color of each node. The second is the "links.txt" file, which contains information on how the nodes are connected and the strength of their connection.

## NETLOGO FEATURES

The link primitives are used to represent and process connections between nodes.

The file primitives are used to read data from external files.
@#$#@#$#@
default
true
0
Polygon -7500403 true true 150 5 40 250 150 205 260 250

airplane
true
0
Polygon -7500403 true true 150 0 135 15 120 60 120 105 15 165 15 195 120 180 135 240 105 270 120 285 150 270 180 285 210 270 165 240 180 180 285 195 285 165 180 105 180 60 165 15

arrow
true
0
Polygon -7500403 true true 150 0 0 150 105 150 105 293 195 293 195 150 300 150

box
false
0
Polygon -7500403 true true 150 285 285 225 285 75 150 135
Polygon -7500403 true true 150 135 15 75 150 15 285 75
Polygon -7500403 true true 15 75 15 225 150 285 150 135
Line -16777216 false 150 285 150 135
Line -16777216 false 150 135 15 75
Line -16777216 false 150 135 285 75

bug
true
0
Circle -7500403 true true 96 182 108
Circle -7500403 true true 110 127 80
Circle -7500403 true true 110 75 80
Line -7500403 true 150 100 80 30
Line -7500403 true 150 100 220 30

butterfly
true
0
Polygon -7500403 true true 150 165 209 199 225 225 225 255 195 270 165 255 150 240
Polygon -7500403 true true 150 165 89 198 75 225 75 255 105 270 135 255 150 240
Polygon -7500403 true true 139 148 100 105 55 90 25 90 10 105 10 135 25 180 40 195 85 194 139 163
Polygon -7500403 true true 162 150 200 105 245 90 275 90 290 105 290 135 275 180 260 195 215 195 162 165
Polygon -16777216 true false 150 255 135 225 120 150 135 120 150 105 165 120 180 150 165 225
Circle -16777216 true false 135 90 30
Line -16777216 false 150 105 195 60
Line -16777216 false 150 105 105 60

car
false
0
Polygon -7500403 true true 300 180 279 164 261 144 240 135 226 132 213 106 203 84 185 63 159 50 135 50 75 60 0 150 0 165 0 225 300 225 300 180
Circle -16777216 true false 180 180 90
Circle -16777216 true false 30 180 90
Polygon -16777216 true false 162 80 132 78 134 135 209 135 194 105 189 96 180 89
Circle -7500403 true true 47 195 58
Circle -7500403 true true 195 195 58

circle
false
0
Circle -7500403 true true 0 0 300

circle 2
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240

cow
false
0
Polygon -7500403 true true 200 193 197 249 179 249 177 196 166 187 140 189 93 191 78 179 72 211 49 209 48 181 37 149 25 120 25 89 45 72 103 84 179 75 198 76 252 64 272 81 293 103 285 121 255 121 242 118 224 167
Polygon -7500403 true true 73 210 86 251 62 249 48 208
Polygon -7500403 true true 25 114 16 195 9 204 23 213 25 200 39 123

cylinder
false
0
Circle -7500403 true true 0 0 300

dot
false
0
Circle -7500403 true true 90 90 120

face happy
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 255 90 239 62 213 47 191 67 179 90 203 109 218 150 225 192 218 210 203 227 181 251 194 236 217 212 240

face neutral
false
0
Circle -7500403 true true 8 7 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Rectangle -16777216 true false 60 195 240 225

face sad
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 168 90 184 62 210 47 232 67 244 90 220 109 205 150 198 192 205 210 220 227 242 251 229 236 206 212 183

fish
false
0
Polygon -1 true false 44 131 21 87 15 86 0 120 15 150 0 180 13 214 20 212 45 166
Polygon -1 true false 135 195 119 235 95 218 76 210 46 204 60 165
Polygon -1 true false 75 45 83 77 71 103 86 114 166 78 135 60
Polygon -7500403 true true 30 136 151 77 226 81 280 119 292 146 292 160 287 170 270 195 195 210 151 212 30 166
Circle -16777216 true false 215 106 30

flag
false
0
Rectangle -7500403 true true 60 15 75 300
Polygon -7500403 true true 90 150 270 90 90 30
Line -7500403 true 75 135 90 135
Line -7500403 true 75 45 90 45

flower
false
0
Polygon -10899396 true false 135 120 165 165 180 210 180 240 150 300 165 300 195 240 195 195 165 135
Circle -7500403 true true 85 132 38
Circle -7500403 true true 130 147 38
Circle -7500403 true true 192 85 38
Circle -7500403 true true 85 40 38
Circle -7500403 true true 177 40 38
Circle -7500403 true true 177 132 38
Circle -7500403 true true 70 85 38
Circle -7500403 true true 130 25 38
Circle -7500403 true true 96 51 108
Circle -16777216 true false 113 68 74
Polygon -10899396 true false 189 233 219 188 249 173 279 188 234 218
Polygon -10899396 true false 180 255 150 210 105 210 75 240 135 240

house
false
0
Rectangle -7500403 true true 45 120 255 285
Rectangle -16777216 true false 120 210 180 285
Polygon -7500403 true true 15 120 150 15 285 120
Line -16777216 false 30 120 270 120

leaf
false
0
Polygon -7500403 true true 150 210 135 195 120 210 60 210 30 195 60 180 60 165 15 135 30 120 15 105 40 104 45 90 60 90 90 105 105 120 120 120 105 60 120 60 135 30 150 15 165 30 180 60 195 60 180 120 195 120 210 105 240 90 255 90 263 104 285 105 270 120 285 135 240 165 240 180 270 195 240 210 180 210 165 195
Polygon -7500403 true true 135 195 135 240 120 255 105 255 105 285 135 285 165 240 165 195

line
true
0
Line -7500403 true 150 0 150 300

line-half
true
0
Line -7500403 true 150 0 150 150

pentagon
false
0
Polygon -7500403 true true 150 15 15 120 60 285 240 285 285 120

person
false
0
Circle -7500403 true true 110 5 80
Polygon -7500403 true true 105 90 120 195 90 285 105 300 135 300 150 225 165 300 195 300 210 285 180 195 195 90
Rectangle -7500403 true true 127 79 172 94
Polygon -7500403 true true 195 90 240 150 225 180 165 105
Polygon -7500403 true true 105 90 60 150 75 180 135 105

plant
false
0
Rectangle -7500403 true true 135 90 165 300
Polygon -7500403 true true 135 255 90 210 45 195 75 255 135 285
Polygon -7500403 true true 165 255 210 210 255 195 225 255 165 285
Polygon -7500403 true true 135 180 90 135 45 120 75 180 135 210
Polygon -7500403 true true 165 180 165 210 225 180 255 120 210 135
Polygon -7500403 true true 135 105 90 60 45 45 75 105 135 135
Polygon -7500403 true true 165 105 165 135 225 105 255 45 210 60
Polygon -7500403 true true 135 90 120 45 150 15 180 45 165 90

square
false
0
Rectangle -7500403 true true 30 30 270 270

square 2
false
0
Rectangle -7500403 true true 30 30 270 270
Rectangle -16777216 true false 60 60 240 240

star
false
0
Polygon -7500403 true true 151 1 185 108 298 108 207 175 242 282 151 216 59 282 94 175 3 108 116 108

target
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240
Circle -7500403 true true 60 60 180
Circle -16777216 true false 90 90 120
Circle -7500403 true true 120 120 60

tree
false
0
Circle -7500403 true true 118 3 94
Rectangle -6459832 true false 120 195 180 300
Circle -7500403 true true 65 21 108
Circle -7500403 true true 116 41 127
Circle -7500403 true true 45 90 120
Circle -7500403 true true 104 74 152

triangle
false
0
Polygon -7500403 true true 150 30 15 255 285 255

triangle 2
false
0
Polygon -7500403 true true 150 30 15 255 285 255
Polygon -16777216 true false 151 99 225 223 75 224

truck
false
0
Rectangle -7500403 true true 4 45 195 187
Polygon -7500403 true true 296 193 296 150 259 134 244 104 208 104 207 194
Rectangle -1 true false 195 60 195 105
Polygon -16777216 true false 238 112 252 141 219 141 218 112
Circle -16777216 true false 234 174 42
Rectangle -7500403 true true 181 185 214 194
Circle -16777216 true false 144 174 42
Circle -16777216 true false 24 174 42
Circle -7500403 false true 24 174 42
Circle -7500403 false true 144 174 42
Circle -7500403 false true 234 174 42

turtle
true
0
Polygon -10899396 true false 215 204 240 233 246 254 228 266 215 252 193 210
Polygon -10899396 true false 195 90 225 75 245 75 260 89 269 108 261 124 240 105 225 105 210 105
Polygon -10899396 true false 105 90 75 75 55 75 40 89 31 108 39 124 60 105 75 105 90 105
Polygon -10899396 true false 132 85 134 64 107 51 108 17 150 2 192 18 192 52 169 65 172 87
Polygon -10899396 true false 85 204 60 233 54 254 72 266 85 252 107 210
Polygon -7500403 true true 119 75 179 75 209 101 224 135 220 225 175 261 128 261 81 224 74 135 88 99

wheel
false
0
Circle -7500403 true true 3 3 294
Circle -16777216 true false 30 30 240
Line -7500403 true 150 285 150 15
Line -7500403 true 15 150 285 150
Circle -7500403 true true 120 120 60
Line -7500403 true 216 40 79 269
Line -7500403 true 40 84 269 221
Line -7500403 true 40 216 269 79
Line -7500403 true 84 40 221 269

x
false
0
Polygon -7500403 true true 270 75 225 30 30 225 75 270
Polygon -7500403 true true 30 75 75 30 270 225 225 270

@#$#@#$#@
NetLogo 5.2.0
@#$#@#$#@
import-network
@#$#@#$#@
@#$#@#$#@
<experiments>
  <experiment name="NS_ND_R3" repetitions="1" runMetricsEveryStep="true">
    <setup>setup</setup>
    <go>go</go>
    <timeLimit steps="100"/>
    <metric>agent-persuaded</metric>
    <metric>average-influence</metric>
    <metric>average-persuation</metric>
    <metric>persuaded</metric>
    <metric>pressure</metric>
    <metric>attitude</metric>
    <metric>my-pressure</metric>
    <steppedValueSet variable="random-seed" first="1" step="1" last="100"/>
    <enumeratedValueSet variable="non-susceptible">
      <value value="true"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="disappoint">
      <value value="false"/>
    </enumeratedValueSet>
  </experiment>
  <experiment name="SIM_INJPOINTS_1600" repetitions="1" runMetricsEveryStep="true">
    <setup>setup</setup>
    <go>go</go>
    <timeLimit steps="90"/>
    <metric>agent-persuaded</metric>
    <metric>average-influence</metric>
    <metric>average-persuation</metric>
    <metric>persuaded</metric>
    <metric>pressure</metric>
    <metric>attitude</metric>
    <metric>my-pressure</metric>
    <steppedValueSet variable="random-seed" first="1" step="1" last="20"/>
    <enumeratedValueSet variable="non-susceptible">
      <value value="true"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="disappoint">
      <value value="true"/>
    </enumeratedValueSet>
    <steppedValueSet variable="me" first="0" step="1" last="79"/>
  </experiment>
  <experiment name="SIM_INJPOINTS_535" repetitions="1" runMetricsEveryStep="true">
    <setup>setup</setup>
    <go>go</go>
    <timeLimit steps="600"/>
    <metric>agent-persuaded</metric>
    <metric>average-influence</metric>
    <metric>average-persuation</metric>
    <metric>persuaded</metric>
    <metric>pressure</metric>
    <metric>attitude</metric>
    <metric>my-pressure</metric>
    <steppedValueSet variable="random-seed" first="1" step="1" last="5"/>
    <enumeratedValueSet variable="disappoint">
      <value value="false"/>
    </enumeratedValueSet>
    <steppedValueSet variable="me" first="0" step="1" last="106"/>
  </experiment>
  <experiment name="SIM_INJPOINTS_35" repetitions="1" runMetricsEveryStep="true">
    <setup>setup</setup>
    <go>go</go>
    <timeLimit steps="570"/>
    <metric>agent-persuaded</metric>
    <metric>average-influence</metric>
    <metric>average-persuation</metric>
    <metric>persuaded</metric>
    <steppedValueSet variable="random-seed" first="1" step="1" last="5"/>
    <enumeratedValueSet variable="disappoint">
      <value value="false"/>
    </enumeratedValueSet>
    <steppedValueSet variable="me" first="0" step="1" last="35"/>
  </experiment>
  <experiment name="SIM_INJPOINTS_70" repetitions="1" runMetricsEveryStep="true">
    <setup>setup</setup>
    <go>go</go>
    <timeLimit steps="570"/>
    <metric>agent-persuaded</metric>
    <metric>average-influence</metric>
    <metric>average-persuation</metric>
    <metric>persuaded</metric>
    <steppedValueSet variable="random-seed" first="1" step="1" last="5"/>
    <enumeratedValueSet variable="disappoint">
      <value value="false"/>
    </enumeratedValueSet>
    <steppedValueSet variable="me" first="36" step="1" last="70"/>
  </experiment>
  <experiment name="SIM_INJPOINTS_106" repetitions="1" runMetricsEveryStep="true">
    <setup>setup</setup>
    <go>go</go>
    <timeLimit steps="570"/>
    <metric>agent-persuaded</metric>
    <metric>average-influence</metric>
    <metric>average-persuation</metric>
    <metric>persuaded</metric>
    <steppedValueSet variable="random-seed" first="1" step="1" last="5"/>
    <enumeratedValueSet variable="disappoint">
      <value value="false"/>
    </enumeratedValueSet>
    <steppedValueSet variable="me" first="71" step="1" last="106"/>
  </experiment>
</experiments>
@#$#@#$#@
@#$#@#$#@
default
0.0
-0.2 0 0.0 1.0
0.0 1 1.0 0.0
0.2 0 0.0 1.0
link direction
true
0
Line -7500403 true 150 150 90 180
Line -7500403 true 150 150 210 180

@#$#@#$#@
0
@#$#@#$#@
