globals [
  membrane-edge-x  ;; horizontal distance from center to edge of membrane
  membrane-edge-y  ;; vertical distance from center to edge of membrane
  membrane-center
  detector-value-1
  detector-value-2
  membrane-surface
  atom-batch-twist
 ; driver-vibration-frequency
  red-detector-size
  blue-detector-size
  length-of-simulation
 ; stength-of-push
  empty-space
  #atoms
  vibrate-particles?
  dark-friction-in-medium
  stiffness
  distance-of-blue-squares-from-sound-source
  particle-shape
  friction-in-medium
]

breed [grids grid]
breed [particles particle]
breed [dark-particles dark-particle]
breed [boundaries boundary]
breed [atoms atom]
breed [detectors detector]

particles-own [
  edge?            ;; are we on the edge of the membrane?
  driver?          ;; are we part of the green driving plate?
  x                ;; position on x axis in space
  y                ;; position on y axis in space
  z                ;; position on z axis in space
  velocity         ;; velocity along z axis
  neighbor-particles ;; agentset of particles adjacent to us
]

dark-particles-own [
  edge?
  driver?
  x                ;; position on x axis in space
  y                ;; position on y axis in space
  z                ;; position on z axis in space
  velocity         ;; velocity along z axis
  neighbor-particles ;; agentset of particles adjacent to us
]

boundaries-own [
  edge?
  driver?
  x                ;; position on x axis in space
  y                ;; position on y axis in space
  z                ;; position on z axis in space
  velocity         ;; velocity along z axis
  neighbor-particles ;; agentset of particles adjacent to us
]


patches-own [detector? detector-number]

atoms-own [kind x y offset-distance]


to setup
  clear-all
  set stiffness 2
  set vibrate-particles? true
  set empty-space 2
  set #atoms 3
  set friction-in-medium 0
  set distance-of-blue-squares-from-sound-source 10
  set dark-friction-in-medium 6
  ;set stength-of-push 15
  set length-of-simulation 749
 ; set driver-vibration-frequency 30
  set red-detector-size 1
  set blue-detector-size 1
  set atom-batch-twist false
  set membrane-surface ""
  set membrane-surface "rigid"
  set particle-shape "empty circle"




  ask patches with [(pxcor <= max-pxcor  - 1) and pycor >= (min-pycor + empty-space) and pycor <= (max-pycor - empty-space)]
    [ sprout 1
        [ set breed particles
          set color green
           set edge? false
          set driver? (( pxcor >= min-pxcor and pxcor <= min-pxcor + 5) and pxcor != max-pxcor and pycor >= (min-pycor + empty-space) and pycor <= (max-pycor - empty-space))
          if driver? [ set color orange ]
          set x xcor
          set y ycor
          set z 0
          set velocity 0
          repack ]
        ]

   ask patches with [(pxcor <= max-pxcor  - 1) and pycor >= (min-pycor + empty-space) and pycor <= (max-pycor - empty-space)][
     sprout 1
     [
       set breed dark-particles
       set edge? false
       set driver? false

       set x xcor
       set y ycor
       set z 0

       set velocity 0
       set hidden? true
       repack
     ]
   ]
   ask patches with [(pxcor = max-pxcor) and pycor >= (min-pycor + empty-space) and pycor <= (max-pycor - empty-space)][
     sprout 1
     [
       set breed boundaries
       set edge? false
       set driver? false
       set color violet
       set x xcor
       set y ycor
       set z 0
       set velocity 0
       set hidden? true
       repack
     ]
   ]

  ask particles
    [
      let these-particle-neighbors particles-on neighbors4
      let these-boundary-neighbors boundaries-on neighbors4
      let myxcor x
      if (driver? and pxcor = min-pxcor + 5) [set hidden? true]
      set shape "square"
      set size 2

    ifelse myxcor = (max-pxcor - 1) [set neighbor-particles (turtle-set these-particle-neighbors these-boundary-neighbors) with [x != myxcor] ]
      [  set neighbor-particles these-particle-neighbors with [x != myxcor]  ]
     ]

    ask dark-particles
    [
      let these-dark-neighbors dark-particles-on neighbors4
      let these-boundary-neighbors boundaries-on neighbors4
      let myxcor x
      ifelse myxcor = (max-pxcor - 1) [ set neighbor-particles (turtle-set these-dark-neighbors these-boundary-neighbors) with [x != myxcor]]
      [ set neighbor-particles these-dark-neighbors with [x != myxcor]   ]
   ]

   ask boundaries
    [
      let these-dark-neighbors dark-particles-on neighbors4
      let these-particle-neighbors particles-on neighbors4
      let myxcor x
      set neighbor-particles (turtle-set these-dark-neighbors these-particle-neighbors) with [x != myxcor]
     ]

    ask patches [
      let min-xpos -24

      if (pxcor >= (min-xpos + distance-of-blue-squares-from-sound-source) and pxcor <= (min-xpos + distance-of-blue-squares-from-sound-source + 2)  ) and pycor = 0
         [add-detector-stamp 1 [100 100 255 250]]


    ]

    ask patches [
    set detector? false
    sprout 1 [set breed grids set shape "grid" set color [255 255 255 55] stamp die]
    ]

  calculate-detector-values
  make-atoms
  repack
  reset-ticks
end

to add-detector-stamp [detector-n this-color]
  set detector-number detector-n
  set detector? true
  sprout 1 [
   set breed detectors
   set shape "square"
   set color this-color
   stamp
   die
  ]
end


to make-atoms



   ask particles with [not edge? and not driver?] [
      let parent self
      let twist (random 4) * 15
      let my-size .4
      let my-color [0 255 0 150]
     if #atoms = 3 [
       let counter 0
       repeat 3 [
         ;show counter
         hatch 1 [
           let offset -15 + random 30
           set breed atoms
           set heading (0 + twist + offset + counter)
           fd .3
           set size my-size
           set offset-distance (xcor  - pxcor)
           set color my-color
           set shape particle-shape
           set hidden? not show-particles-in-medium?
           create-link-from parent [tie set hidden? true]
          ; __set-line-thickness .05
           set kind "atoms"
          ]
         set counter counter + 120
       ]


     ]
     if #atoms = 1 [
      hatch 1 [
        let offset 0
        set breed atoms
        set heading (0 + twist + offset)
        set size my-size * 2
        set color my-color
        set shape particle-shape
        set hidden? not show-particles-in-medium?
        create-link-from parent [tie set hidden? true]
       ; __set-line-thickness .05
        set kind "atoms"
      ]
     ]
    set hidden? true

   ]


end

to repack  ;; turtle procedure'
  let my-xcor 0
 ask (turtle-set particles boundaries dark-particles) [
  if not edge?
    [
      setxy x y
      set heading -90

      fd z / slide-step

      ]
   ]
end




to go
  if (ticks >  length-of-simulation) [stop]

  if vibrate-particles? [ask atoms [
      rt random 180 lt random 180]

    ]

  ask particles with [not edge?]
    [ propagate-across-particles friction-in-medium ]
  ask boundaries
    [ propagate-across-particles friction-in-medium]
  ask dark-particles
    [ propagate-across-particles dark-friction-in-medium]

  ask particles

    [
       let driver-vibration-frequency vibration-frequency * 60
      ifelse driver?
        [ set z (vibration-amplitude * -1 * (sin (0.1 * driver-vibration-frequency * ticks)))
          if (0.1 * driver-vibration-frequency * ticks) / 360 >= #-of-repeated-vibrations [set z 0] ]
        [ set z (z + velocity)]
     ]
  ask boundaries      [ set z (z + velocity)]
  ask dark-particles  [ set z (z + velocity)]
  ask atoms [set shape particle-shape]




  repack
  calculate-detector-values
      ask atoms [
       ifelse show-particles-in-medium?
       [set hidden? not show-particles-in-medium?]
       [set hidden? not show-particles-in-medium?]
      ]
    ;;  density-over-space
  tick
end

to calculate-detector-values
  let value-1 0
  let value-2 0
  let this-pxcor 0
  ifelse Graph-B
  [
    set detector-value-1 count atoms with [detector? and detector-number = 1]
    set detector-value-2 count atoms with [detector? and detector-number = 2]
  ]
  [
    set detector-value-1 "disabled"
    set detector-value-2 "disabled"
  ]
end

to propagate-across-particles [this-friction-in-medium]  ;; turtle procedure -- propagates the wave from neighboring particles
  set velocity (velocity +  (stiffness * 0.01) *  (sum [z] of neighbor-particles -  2 * z))
  set velocity (((1000 - this-friction-in-medium) / 1000) * velocity)
end


to watch-a-particle
   let current-atoms atoms with [x = -18 and y = 1]
   if any? current-atoms [
      let this-atom min-n-of 1  current-atoms [who]
      ask atoms [set color [0 255 0 150]]
      ask this-atom [set color [255 0 0 150]  watch-me]

   ]

end

to density-over-space
  set-current-plot "Graph A: # of particles in each square across the medium "
  clear-plot
  let this-counter -30
  let #atoms-p 0
  ;set atoms-here 0
  repeat 60 [
    set this-counter this-counter + 1
    create-temporary-plot-pen (word this-counter)

    set-plot-pen-mode 1 ; bar mode

    ask patch this-counter 0 [
      set #atoms-p count atoms-here
       set-plot-pen-color green - 1
      ]
    plotxy this-counter #atoms-p
  ]


end



to inspect-blue-detector
  ask patch (-23 + distance-of-blue-squares-from-sound-source) 1 [
   ; inspect self
  ]
end


; Copyright 1997 Uri Wilensky.
; See Info tab for full copyright and license.
@#$#@#$#@
GRAPHICS-WINDOW
265
162
1066
262
-1
-1
13.0
1
10
1
1
1
0
0
1
1
-30
30
-3
3
1
1
1
ticks
30.0

BUTTON
20
17
109
50
NIL
setup
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
19
52
111
85
go/pause
go
T
1
T
OBSERVER
NIL
NIL
NIL
NIL
0

TEXTBOX
518
664
660
692
Particle display settings
11
0.0
0

SLIDER
664
748
800
781
particle-size
particle-size
0
2
0.5
.1
1
NIL
HORIZONTAL

SLIDER
664
710
805
743
slide-step
slide-step
0
10
10.0
.1
1
NIL
HORIZONTAL

BUTTON
26
762
214
796
inspect a patch
ask patch 13 -1 [\nlet this-particle one-of particles-here\nset pcolor gray - 2\ninspect this-particle\n]
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
216
763
279
796
NIL
go
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

PLOT
248
10
1081
163
Graph A: # of particles in each square across the medium 
NIL
# of particles
-30.0
32.0
0.0
9.0
false
false
"" ""
PENS
"default" 1.0 0 -12087248 true "" "if graph-A [density-over-space]"

PLOT
593
266
1075
412
Graph B: # of particles in blue squares vs. time
time
# of particles
0.0
750.0
0.0
16.0
true
false
"" ""
PENS
"default" 1.0 0 -14454117 true "" "if graph-B [plot detector-value-2]"

SLIDER
22
148
240
181
#-of-repeated-vibrations
#-of-repeated-vibrations
1
3
1.0
1
1
NIL
HORIZONTAL

BUTTON
118
52
173
85
>
go
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
0

MONITOR
178
46
244
91
time
ticks
17
1
11

MONITOR
284
282
445
327
# particles in blue squares
detector-value-1
17
1
11

SWITCH
475
378
586
411
Graph-B
Graph-B
1
1
-1000

SLIDER
22
113
240
146
vibration-amplitude
vibration-amplitude
3
15
8.0
1
1
NIL
HORIZONTAL

SLIDER
22
184
241
217
vibration-frequency
vibration-frequency
.25
3
1.0
.25
1
waves/sec
HORIZONTAL

SWITCH
19
248
241
281
show-particles-in-medium?
show-particles-in-medium?
0
1
-1000

TEXTBOX
84
94
234
112
Sound source
14
0.0
1

TEXTBOX
107
227
216
245
Medium
14
0.0
1

SWITCH
133
10
244
43
Graph-A
Graph-A
1
1
-1000

TEXTBOX
505
298
596
332
<---------
14
93.0
1

TEXTBOX
495
264
510
343
^\n|\n|
14
94.0
1

TEXTBOX
457
298
505
316
--->
14
93.0
1

@#$#@#$#@
## WHAT IS IT?

## HOW IT WORKS

## HOW TO USE IT

## THINGS TO TRY

## EXTENDING THE MODEL

## NETLOGO FEATURES

## CREDITS AND REFERENCES

Developed by Michael Novak, Northwestern University, Evanston, IL.

This model is based on the code from the NetLogo Wave Machine model:  http://ccl.northwestern.edu/netlogo/models/WaveMachine.  Center for Connected Learning and Computer-Based Modeling, Northwestern University, Evanston, IL.


## HOW TO CITE

If you mention this model in a publication, we ask that you include this citation

* Wilensky, U. (1999). NetLogo. http://ccl.northwestern.edu/netlogo/. Center for Connected Learning and Computer-Based Modeling, Northwestern University, Evanston, IL.


## COPYRIGHT AND LICENSE

Copyright 1997 Uri Wilensky.

![CC BY-NC-SA 3.0](http://i.creativecommons.org/l/by-nc-sa/3.0/88x31.png)

This work is licensed under the Creative Commons Attribution-NonCommercial-ShareAlike 3.0 License.  To view a copy of this license, visit http://creativecommons.org/licenses/by-nc-sa/3.0/ or send a letter to Creative Commons, 559 Nathan Abbott Way, Stanford, California 94305, USA.

Commercial licenses are also available. To inquire about commercial licenses, please contact Uri Wilensky at uri@northwestern.edu.

This model was created as part of the project: CONNECTED MATHEMATICS: MAKING SENSE OF COMPLEX PHENOMENA THROUGH BUILDING OBJECT-BASED PARALLEL MODELS (OBPML).  The project gratefully acknowledges the support of the National Science Foundation (Applications of Advanced Technologies Program) -- grant numbers RED #9552950 and REC #9632612.

This model was converted to NetLogo as part of the projects: PARTICIPATORY SIMULATIONS: NETWORK-BASED DESIGN FOR SYSTEMS LEARNING IN CLASSROOMS and/or INTEGRATED SIMULATION AND MODELING ENVIRONMENT. The project gratefully acknowledges the support of the National Science Foundation (REPP & ROLE programs) -- grant numbers REC #9814682 and REC-0126227. Converted from StarLogoT to NetLogo, 2001.
@#$#@#$#@
default
true
0
Polygon -7500403 true true 150 5 40 250 150 205 260 250

airplane
true
0
Polygon -7500403 true true 150 0 135 15 120 60 120 105 15 165 15 195 120 180 135 240 105 270 120 285 150 270 180 285 210 270 165 240 180 180 285 195 285 165 180 105 180 60 165 15

arrow
true
0
Polygon -7500403 true true 150 0 0 150 105 150 105 293 195 293 195 150 300 150

box
false
0
Polygon -7500403 true true 150 285 285 225 285 75 150 135
Polygon -7500403 true true 150 135 15 75 150 15 285 75
Polygon -7500403 true true 15 75 15 225 150 285 150 135
Line -16777216 false 150 285 150 135
Line -16777216 false 150 135 15 75
Line -16777216 false 150 135 285 75

bug
true
0
Circle -7500403 true true 96 182 108
Circle -7500403 true true 110 127 80
Circle -7500403 true true 110 75 80
Line -7500403 true 150 100 80 30
Line -7500403 true 150 100 220 30

butterfly
true
0
Polygon -7500403 true true 150 165 209 199 225 225 225 255 195 270 165 255 150 240
Polygon -7500403 true true 150 165 89 198 75 225 75 255 105 270 135 255 150 240
Polygon -7500403 true true 139 148 100 105 55 90 25 90 10 105 10 135 25 180 40 195 85 194 139 163
Polygon -7500403 true true 162 150 200 105 245 90 275 90 290 105 290 135 275 180 260 195 215 195 162 165
Polygon -16777216 true false 150 255 135 225 120 150 135 120 150 105 165 120 180 150 165 225
Circle -16777216 true false 135 90 30
Line -16777216 false 150 105 195 60
Line -16777216 false 150 105 105 60

car
false
0
Polygon -7500403 true true 300 180 279 164 261 144 240 135 226 132 213 106 203 84 185 63 159 50 135 50 75 60 0 150 0 165 0 225 300 225 300 180
Circle -16777216 true false 180 180 90
Circle -16777216 true false 30 180 90
Polygon -16777216 true false 162 80 132 78 134 135 209 135 194 105 189 96 180 89
Circle -7500403 true true 47 195 58
Circle -7500403 true true 195 195 58

circle 2
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240

cow
false
0
Polygon -7500403 true true 200 193 197 249 179 249 177 196 166 187 140 189 93 191 78 179 72 211 49 209 48 181 37 149 25 120 25 89 45 72 103 84 179 75 198 76 252 64 272 81 293 103 285 121 255 121 242 118 224 167
Polygon -7500403 true true 73 210 86 251 62 249 48 208
Polygon -7500403 true true 25 114 16 195 9 204 23 213 25 200 39 123

cylinder
false
0
Circle -7500403 true true 0 0 300

detector
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240

dot
false
0
Circle -7500403 true true 90 90 120

empty circle
true
0
Circle -7500403 false true 30 30 210

face happy
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 255 90 239 62 213 47 191 67 179 90 203 109 218 150 225 192 218 210 203 227 181 251 194 236 217 212 240

face neutral
false
0
Circle -7500403 true true 8 7 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Rectangle -16777216 true false 60 195 240 225

face sad
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 168 90 184 62 210 47 232 67 244 90 220 109 205 150 198 192 205 210 220 227 242 251 229 236 206 212 183

filled circle
true
0
Circle -7500403 true true 27 27 216

fish
false
0
Polygon -1 true false 44 131 21 87 15 86 0 120 15 150 0 180 13 214 20 212 45 166
Polygon -1 true false 135 195 119 235 95 218 76 210 46 204 60 165
Polygon -1 true false 75 45 83 77 71 103 86 114 166 78 135 60
Polygon -7500403 true true 30 136 151 77 226 81 280 119 292 146 292 160 287 170 270 195 195 210 151 212 30 166
Circle -16777216 true false 215 106 30

flag
false
0
Rectangle -7500403 true true 60 15 75 300
Polygon -7500403 true true 90 150 270 90 90 30
Line -7500403 true 75 135 90 135
Line -7500403 true 75 45 90 45

flower
false
0
Polygon -10899396 true false 135 120 165 165 180 210 180 240 150 300 165 300 195 240 195 195 165 135
Circle -7500403 true true 85 132 38
Circle -7500403 true true 130 147 38
Circle -7500403 true true 192 85 38
Circle -7500403 true true 85 40 38
Circle -7500403 true true 177 40 38
Circle -7500403 true true 177 132 38
Circle -7500403 true true 70 85 38
Circle -7500403 true true 130 25 38
Circle -7500403 true true 96 51 108
Circle -16777216 true false 113 68 74
Polygon -10899396 true false 189 233 219 188 249 173 279 188 234 218
Polygon -10899396 true false 180 255 150 210 105 210 75 240 135 240

grid
false
0
Rectangle -7500403 false true 0 0 300 300

house
false
0
Rectangle -7500403 true true 45 120 255 285
Rectangle -16777216 true false 120 210 180 285
Polygon -7500403 true true 15 120 150 15 285 120
Line -16777216 false 30 120 270 120

leaf
false
0
Polygon -7500403 true true 150 210 135 195 120 210 60 210 30 195 60 180 60 165 15 135 30 120 15 105 40 104 45 90 60 90 90 105 105 120 120 120 105 60 120 60 135 30 150 15 165 30 180 60 195 60 180 120 195 120 210 105 240 90 255 90 263 104 285 105 270 120 285 135 240 165 240 180 270 195 240 210 180 210 165 195
Polygon -7500403 true true 135 195 135 240 120 255 105 255 105 285 135 285 165 240 165 195

line
true
0
Line -7500403 true 150 0 150 300

line half
true
0
Line -7500403 true 150 0 150 150

nothing
true
0

pentagon
false
0
Polygon -7500403 true true 150 15 15 120 60 285 240 285 285 120

person
false
0
Circle -7500403 true true 110 5 80
Polygon -7500403 true true 105 90 120 195 90 285 105 300 135 300 150 225 165 300 195 300 210 285 180 195 195 90
Rectangle -7500403 true true 127 79 172 94
Polygon -7500403 true true 195 90 240 150 225 180 165 105
Polygon -7500403 true true 105 90 60 150 75 180 135 105

plant
false
0
Rectangle -7500403 true true 135 90 165 300
Polygon -7500403 true true 135 255 90 210 45 195 75 255 135 285
Polygon -7500403 true true 165 255 210 210 255 195 225 255 165 285
Polygon -7500403 true true 135 180 90 135 45 120 75 180 135 210
Polygon -7500403 true true 165 180 165 210 225 180 255 120 210 135
Polygon -7500403 true true 135 105 90 60 45 45 75 105 135 135
Polygon -7500403 true true 165 105 165 135 225 105 255 45 210 60
Polygon -7500403 true true 135 90 120 45 150 15 180 45 165 90

solid circle
true
0
Circle -7500403 true true 2 2 297

square
false
0
Rectangle -7500403 true true 0 -15 300 300

square 2
false
0
Rectangle -7500403 true true 30 30 270 270
Rectangle -16777216 true false 60 60 240 240

star
false
0
Polygon -7500403 true true 151 1 185 108 298 108 207 175 242 282 151 216 59 282 94 175 3 108 116 108

target
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240
Circle -7500403 true true 60 60 180
Circle -16777216 true false 90 90 120
Circle -7500403 true true 120 120 60

tree
false
0
Circle -7500403 true true 118 3 94
Rectangle -6459832 true false 120 195 180 300
Circle -7500403 true true 65 21 108
Circle -7500403 true true 116 41 127
Circle -7500403 true true 45 90 120
Circle -7500403 true true 104 74 152

triangle
false
0
Polygon -7500403 true true 150 30 15 255 285 255

triangle 2
false
0
Polygon -7500403 true true 150 30 15 255 285 255
Polygon -16777216 true false 151 99 225 223 75 224

truck
false
0
Rectangle -7500403 true true 4 45 195 187
Polygon -7500403 true true 296 193 296 150 259 134 244 104 208 104 207 194
Rectangle -1 true false 195 60 195 105
Polygon -16777216 true false 238 112 252 141 219 141 218 112
Circle -16777216 true false 234 174 42
Rectangle -7500403 true true 181 185 214 194
Circle -16777216 true false 144 174 42
Circle -16777216 true false 24 174 42
Circle -7500403 false true 24 174 42
Circle -7500403 false true 144 174 42
Circle -7500403 false true 234 174 42

turtle
true
0
Polygon -10899396 true false 215 204 240 233 246 254 228 266 215 252 193 210
Polygon -10899396 true false 195 90 225 75 245 75 260 89 269 108 261 124 240 105 225 105 210 105
Polygon -10899396 true false 105 90 75 75 55 75 40 89 31 108 39 124 60 105 75 105 90 105
Polygon -10899396 true false 132 85 134 64 107 51 108 17 150 2 192 18 192 52 169 65 172 87
Polygon -10899396 true false 85 204 60 233 54 254 72 266 85 252 107 210
Polygon -7500403 true true 119 75 179 75 209 101 224 135 220 225 175 261 128 261 81 224 74 135 88 99

wheel
false
0
Circle -7500403 true true 3 3 294
Circle -16777216 true false 30 30 240
Line -7500403 true 150 285 150 15
Line -7500403 true 15 150 285 150
Circle -7500403 true true 120 120 60
Line -7500403 true 216 40 79 269
Line -7500403 true 40 84 269 221
Line -7500403 true 40 216 269 79
Line -7500403 true 84 40 221 269

x
false
0
Polygon -7500403 true true 270 75 225 30 30 225 75 270
Polygon -7500403 true true 30 75 75 30 270 225 225 270
@#$#@#$#@
NetLogo 6.0-BETA2
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
default
0.0
-0.2 0 0.0 1.0
0.0 1 1.0 0.0
0.2 0 0.0 1.0
link direction
true
0
Line -7500403 true 150 150 90 180
Line -7500403 true 150 150 210 180
@#$#@#$#@
0
@#$#@#$#@
