extensions [ sound ]

globals [mean-fitness timing temps population]
breed [agents]
breed [signal]
patches-own [ ]
agents-own [deplacement voisins signaux vie age genome freq amp duree timbre
  fitness deviance enfants signal-voisin couleur memoire]
signal-own [freq amp duree timbre signal-on-off]

to go
signal-in
algorithme-agents
if music = true [musique]
moving-agent
calculation
if population <= 0 [sound:stop-music stop] ; stop si plus d'agents
affichage-datas
end

to setup
sound:stop-music
ca
cp
set timing 0
set population nombre-agent
setup-signal
setup-agent
reset-timer
end

to setup-signal
create-signal nombre-signal [
set shape "circle"
set color red
set heading random-float 360
set pitch random-float 360
fd random 360
set duree 0
set timbre instrument-signal - 1
]
end

to setup-agent
create-agents nombre-agent
[
set heading random-float 360 set pitch random-float 360 fd random-float 360
set vie duree-maximum-vie; duree maximale de vie
set duree 0 ; pret pour jouer un evenement musical
set age "jeune"
set color blue
set enfants 0
set fitness 0
set memoire 0
;normalisation du genome pour mutation et croisement
set genome []
set genome lput random-float 1 genome ; freq 0
set genome lput random-float 1 genome ; amp 1
set genome lput random-float 1 genome ; duree 2
set genome lput random-float 1 genome ; timbre 3
set genome lput random-float 1 genome ; constante jeunesse 4
set genome lput random-float 1 genome ; constante vieillesse 5
set genome lput random-float 1 genome ; constante de vieillissement 6
set genome lput random-float 1 genome ; constante de vitesse de deplacement 7
set genome lput random-float 1 genome ; constante de vision in radius 8
set genome lput random-float 1 genome ; constante de deviance de deplacement 9
set genome lput random-float 1 genome ; constante d'ecoute in radius 10
set genome lput random-float 1 genome ; constante de memoire 11
set genome lput 0 genome ; fitness 12
]
end

to algorithme-agents
let sort-age-enfant 0
  let sort-fitness 0

ask agents [without-interruption ; Attention important pour parallelisme
[
set deplacement (item 7 genome)  * vitesse-deplacement
set deviance (item 9 genome) * deviance-agent
set duree duree - 1
set memoire memoire - 1
set vie vie - (random-float (item 6 genome) * vitesse-generation)
ifelse vie >= (duree-maximum-vie - ((item 4 genome) * %tranche-age)) [set age "jeune" set color blue + couleur]
  [ifelse vie >= ((item 5 genome) * %tranche-age) [set age "adulte" set color green + couleur]
    [ifelse vie > 0 [set age "vieux" set color yellow + couleur
      if random-float 1 <= %mutation [mutation-gene-vieux]]
        [die]]
          ]
set voisins agents in-radius ((item 8 genome) * distance-agent) with [self != myself]
if any? voisins [
  set color pink + couleur
  set fitness fitness + 1
  set genome replace-item 12 genome (fitness / max [fitness] of agents)
  set sort-fitness voisins with [[fitness] of self >= [fitness] of myself]
  set sort-age-enfant sort-fitness with [age = "adulte" and enfants < maximum-enfants]
  if random-float 1 <= %learning and any? sort-fitness
    [learning-agent one-of (sort-fitness with-max [fitness])]
  if random-float 1 <= %naissance and age = "adulte" and enfants < maximum-enfants and any? sort-age-enfant
    [accouplement who one-of (sort-age-enfant with-max [fitness])]
  ]
]
]
end

to mutation-gene-vieux
set genome replace-item random 13 genome random-float 1
end

to learning-agent [gagnant]
let gene-gagnant 0
  let item-gene 0

set item-gene random 6 + 6 ; selection du genome important
set gene-gagnant item item-gene [genome] of gagnant
set genome replace-item item-gene genome gene-gagnant
end

to accouplement [moi lui]
let genome1 0
  let genome2 0
  let gene 0

set genome1 []
set genome2 []
foreach [0 1 2 3 4 5 6 7 8 9 10 11 12] [set gene ?
ifelse random-float 1 <= %croisement [
ifelse random-float 1 <= %mutation [
  set genome1 lput random-float 1 genome1] [set genome1 lput (item gene genome) genome1]
  ifelse random-float 1 <= %mutation [set genome2 lput random-float 1 genome2]
  [set genome2 lput (item gene [genome] of lui) genome2]
  ]
    [ifelse random-float 1 <= %mutation [
    set genome1 lput random-float 1 genome1] [set genome1 lput (item gene [genome] of lui) genome1]
    ifelse random-float 1 <= %mutation [set genome2 lput random-float 1 genome2]
    [set genome2 lput (item gene genome) genome2]
  ]
]
hatch-agents 1 [
set heading random-float 360 set pitch random-float 360 fd random-float 360
set vie duree-maximum-vie
set duree 0
set age "jeune"
set enfants 0
set memoire 0
ifelse random-float 1 <= 0.5 [set genome genome1] [set genome genome2] ; choix d'un des enfants
set fitness item 12 genome * max [fitness] of agents
]
set enfants enfants + 1
ask lui [set enfants enfants + 1]
if count agents > maximum-population [ask turtle moi [die] ask turtle lui [die]];mort des parents
end

to musique
ask agents [
if (any? signaux or any? voisins) and duree <= 0 and memoire > 0 [
  sound:stop-note item timbre sound:instruments freq
  set fitness fitness + 0.5 ; a verifier si necessaire
  set genome replace-item 12 genome (fitness / max [fitness] of agents)
  set freq item 0 genome * 87 + 21
  set amp 127 - (item 1 genome * 127) ; inverse pycor pour velocite reelle
  set duree item 2 genome * tempo-musique
  set timbre floor (item 3 genome * 128)
  sound:play-note item timbre sound:instruments freq amp * volume duree
  ]
]
end

to signal-in
let signal-winner 0

ask signal [
set duree duree - 1
if duree <= 0 [
 ;stop-note item timbre instruments freq
    ifelse random-float 1 <  %signal-in [
      show-turtle
      set signal-on-off "on"
      set heading random-float 360
      set pitch random-float 360
      fd random-float 360 * %mouvement-signal / 10
      set freq (abs zcor / max-pzcor) * 87 + 21
      set amp 127 - ((abs ycor / max-pycor) * 127) ; inverse pycor pour velocite reelle
      set duree (abs xcor / max-pxcor) * tempo-musique
      if random-float 1 < %change-timbre [set timbre random 128]
      ;if music = true [play-note item timbre instruments freq amp * volume duree]
      ]
        [
        hide-turtle
        set signal-on-off "off"
        set heading random-float 360
        set pitch random-float 360
        fd random-float 360 * %mouvement-signal / 10
        set duree (abs xcor / max-pxcor) * tempo-musique
        ]
]
]
ask agents [
set signaux signal in-radius ((item 10 genome) * distance-signal) with [signal-on-off = "on"]
ifelse any? signaux [
  set signal-winner one-of (signaux with-min [distance myself])
    set genome replace-item 0 genome [abs zcor / max-pzcor] of signal-winner
      set genome replace-item 1 genome [abs ycor / max-pycor] of signal-winner
        set genome replace-item 2 genome [abs xcor / max-pxcor] of signal-winner
          set genome replace-item 3 genome [timbre / 128] of signal-winner
              set fitness fitness + 1.5
                set genome replace-item 12 genome (fitness / max [fitness] of agents)
                  set memoire item 11 genome * duree-memoire
                    set couleur 4.9
                      ]
                        [set couleur 0]
]
end

to moving-agent
ask agents [
ifelse any? signaux [
  set heading mean [heading] of signaux + random-float deviance - (deviance / 2)
  set pitch mean [pitch] of signaux + random-float deviance - (deviance / 2)
  set deplacement mean [distance myself] of signaux
  ]
    [ifelse any? voisins [
    set heading mean [heading] of voisins + random-float deviance - (deviance / 2)
    set pitch mean [pitch] of voisins + random-float deviance - (deviance / 2)
    set deplacement mean [distance myself] of voisins
    ]
      [
      set heading heading + random-float deviance - (deviance / 2)
      set pitch pitch + random-float deviance - (deviance / 2)
      set deplacement (item 7 genome)  * vitesse-deplacement
      ]
]
fd vitesse-deplacement * deplacement
]
end

to calculation
set timing timing + 1
set temps timer
set population count agents
end

to affichage-datas
if plot-genes != "off" [
set-current-plot "genomes agents"
set-plot-y-range 0 population
set-histogram-num-bars population
plot-pen-reset
if plot-genes = "gene0-freq" [set-current-plot-pen "gene0-freq"
  histogram [item 0 (item 0 ([genome] of agents ))] of agents]
if plot-genes = "gene1-amp" [set-current-plot-pen "gene1-amp"
  histogram [item 1 (item 0 ([genome] of agents ))] of agents]
if plot-genes = "gene2-duree" [set-current-plot-pen "gene2-duree"
  histogram [item 2 (item 0 ([genome] of agents ))] of agents]
if plot-genes = "gene3-timbre" [set-current-plot-pen "gene3-timbre"
  histogram [item 3 (item 0 ([genome] of agents ))] of agents]
if plot-genes = "gene4-jeunesse" [set-current-plot-pen "gene4-jeunesse"
  histogram [item 4 (item 0 ([genome] of agents ))] of agents]
if plot-genes = "gene5-vieillesse" [set-current-plot-pen "gene5-vieillesse"
  histogram [item 5 (item 0 ([genome] of agents))] of agents]
if plot-genes = "gene6-vieillissement" [set-current-plot-pen "gene6-vieillissement"
  histogram [item 6 (item 0 ([genome] of agents))] of agents]
if plot-genes = "gene7-deplacement" [set-current-plot-pen "gene7-deplacement"
  histogram [item 7 (item 0 ([genome] of agents))] of agents]
if plot-genes = "gene8-vision-radius" [set-current-plot-pen "gene8-vision-radius"
  histogram [item 8 (item 0 ([genome] of agents))] of agents]
if plot-genes = "gene9-deviance" [set-current-plot-pen "gene9-deviance"
  histogram [item 9 (item 0 ([genome] of agents))] of agents]
if plot-genes = "gene10-ecoute-radius" [set-current-plot-pen "gene10-ecoute-radius"
  histogram [item 10 (item 0 ([genome] of agents))] of agents]
if plot-genes = "gene11-memoire" [set-current-plot-pen "gene11-memoire"
  histogram [item 11 (item 0 ([genome] of agents))] of agents]
if plot-genes = "gene12-fitness" [set-current-plot-pen "gene12-fitness"
  histogram [item 12 (item 0 ([genome] of agents ))] of agents]
]
end
@#$#@#$#@
GRAPHICS-WINDOW
0
0
200
221
-1
-1
2.0
1
5
1
1
1
0
1
1
1
0
16
0
16
0
16
1
0
1
ticks

BUTTON
4
10
70
43
NIL
setup
NIL
1
T
OBSERVER
NIL
I
NIL
NIL

BUTTON
77
10
140
43
NIL
go
T
1
T
OBSERVER
NIL
R
NIL
NIL

SLIDER
2
349
174
382
nombre-agent
nombre-agent
1
1000
16
1
1
NIL
HORIZONTAL

SLIDER
183
456
360
489
vitesse-deplacement
vitesse-deplacement
0
10
1
0.1
1
NIL
HORIZONTAL

SLIDER
248
60
340
93
volume
volume
0
1
1
0.1
1
NIL
HORIZONTAL

PLOT
1
103
339
348
genomes agents
genomes
agents
0.0
1.0
0.0
1.0
true
true
PENS
"gene0-freq" 1.0 1 -10141563 true
"gene1-amp" 1.0 1 -14985354 true
"gene2-duree" 1.0 1 -612749 true
"gene3-timbre" 1.0 1 -5509967 true
"gene4-jeunesse" 1.0 1 -955883 true
"gene5-vieillesse" 1.0 1 -7171555 true
"gene6-vieillissement" 1.0 1 -3425830 true
"gene7-deplacement" 1.0 1 -13345367 true
"gene8-vision-radius" 1.0 1 -2674135 true
"gene9-deviance" 1.0 1 -10899396 true
"gene10-ecoute-radius" 1.0 1 -2064490 true
"gene11-memoire" 1.0 1 -6459832 true
"gene12-fitness" 1.0 1 -13791810 true

SLIDER
373
336
552
369
nombre-signal
nombre-signal
0
64
6
1
1
NIL
HORIZONTAL

SLIDER
373
408
577
441
%mouvement-signal
%mouvement-signal
0
1
0.1
0.01
1
NIL
HORIZONTAL

SLIDER
3
418
175
451
distance-agent
distance-agent
0
5
1
0.1
1
NIL
HORIZONTAL

SLIDER
1
490
173
523
deviance-agent
deviance-agent
0
360
360
1
1
NIL
HORIZONTAL

SLIDER
180
420
359
453
vitesse-generation
vitesse-generation
0
10
1
0.1
1
NIL
HORIZONTAL

SLIDER
333
10
467
43
tempo-musique
tempo-musique
0
1000
16
1
1
NIL
HORIZONTAL

SLIDER
177
386
344
419
%tranche-age
%tranche-age
0
100
50
1
1
NIL
HORIZONTAL

SLIDER
341
246
513
279
%mutation
%mutation
0
1
0.1
0.01
1
NIL
HORIZONTAL

SLIDER
341
209
513
242
%croisement
%croisement
0
1
0.5
0.01
1
NIL
HORIZONTAL

SLIDER
1
384
173
417
duree-maximum-vie
duree-maximum-vie
1
256
75
1
1
NIL
HORIZONTAL

SLIDER
340
284
512
317
%learning
%learning
0
1
0.25
0.01
1
NIL
HORIZONTAL

SLIDER
341
138
513
171
%naissance
%naissance
0
1
0.66
0.01
1
NIL
HORIZONTAL

SLIDER
341
172
513
205
maximum-enfants
maximum-enfants
0
32
3
1
1
NIL
HORIZONTAL

MONITOR
141
10
204
55
annees
timing
3
1
11

SLIDER
176
352
342
385
maximum-population
maximum-population
0
1000
32
1
1
NIL
HORIZONTAL

SWITCH
154
58
244
91
music
music
0
1
-1000

CHOOSER
-1
59
150
104
plot-genes
plot-genes
"off" "gene0-freq" "gene1-amp" "gene2-duree" "gene3-timbre" "gene4-jeunesse" "gene5-vieillesse" "gene6-vieillissement" "gene7-deplacement" "gene8-vision-radius" "gene9-deviance" "gene10-ecoute-radius" "gene11-memoire" "gene12-fitness"
13

MONITOR
281
10
331
55
crew
population
3
1
11

MONITOR
204
10
281
55
temps
temps
3
1
11

SLIDER
373
372
545
405
%signal-in
%signal-in
0
1
0.33
0.01
1
NIL
HORIZONTAL

SLIDER
3
453
175
486
distance-signal
distance-signal
0
5
3
0.1
1
NIL
HORIZONTAL

SLIDER
390
53
562
86
instrument-signal
instrument-signal
1
128
1
1
1
NIL
HORIZONTAL

SLIDER
181
492
353
525
duree-memoire
duree-memoire
0
1000
64
1
1
NIL
HORIZONTAL

SLIDER
390
86
562
119
%change-timbre
%change-timbre
0
1
0.15
0.01
1
NIL
HORIZONTAL

@#$#@#$#@
WHAT IS IT?
-----------

Mod?le exp?rimental multi-agents pour la cr?ation musicale.
Chaque agents a un comportement tr?s simple. La mise en oeuvre d'une multitude d'agents et leurs interactions entre eux (et avec un signal entrant), donnent une ?mergence de forme musicale.

HOW IT WORKS
------------

Un agent poss?de un g?nome de 13 g?nes. Chaque g?ne code une particularit? de l'agent.
Il y a 3 codons distincts.
le codons musical:
	le g?ne 0 code la fr?quence
	le g?ne 1 code l'amplitude
	le g?ne 2 code la dur?e
	le g?ne 3 code le timbre
le codons comportemental:
	le g?ne 4 code le temps que passe l'agent dans le stade "enfance"
	le g?ne 5 code le temps que passe l'agent dans le stade "vieillesse"
	le g?ne 6 code la vitesse de vieillissement de l'agent
	le g?ne 7 code la vitesse de d?placement au sein de l'environnement.
	le g?ne 8 code la distance de vision en radius
	le g?ne 9 code la d?viance de d?placement
	le g?ne 10 code la distance d'?coute (du/des signal/aux) en radius
	le g?ne 11 code la dur?e de la m?moire de l'agent.
le codon adaptation:
	le g?ne 12 code la fitness (adaptation) de l'agent.

Au d?but chaque agent re?oit un patrimoine au hasard.
Les r?gles de comportement sont les suivantes:
l'agent se d?place au hasard dans l'espace.
Premi?re r?gle:
	Si dans son champ de vision il y a d'autres agents alors il se joint au groupe. Dans se groupe si il y a un ou plusieurs agents qui ont une fitness meilleure que lui alors il passe en mode apprentissage. Il choisit un g?ne au hasard dans le codon comportemental d'un agent pris au hasard (avec meilleure fitness).
Si il est "adulte" il peut se reproduire avec un autre adulte du groupe (AG).
Deuxi?me r?gle:
	Si dans son champs de vision il y a un ou plusieurs signaux alors l'agent "?coute" le plus proche. Il prend la fr?quence la dur?e la v?locit? et le timbre du signal. Ce sont ces donn?es qu'il va garder en m?moire et jouer le temps donn? par le g?ne 11.
De plus l'agent aura la pr?f?rence de rester au plus pr?s des ?ventuels signaux .

Avec ces r?gles simples les agents "apprennent" ? maximiser leurs comportements pour voir et entendre.


HOW TO USE IT
-------------

Vous pouvez exp?rimenter divers univers.
Le g?nome est normaliser [o <= g?ne <= 1]. Donc se sont les sliders qui d?finissent l 'amplitude des param?tres du syst?me.


THINGS TO NOTICE
----------------
This section could give some ideas of things for the user to notice while running the model.


THINGS TO TRY
-------------
This section could give some ideas of things for the user to try to do (move sliders, switches, etc.) with the model.


EXTENDING THE MODEL
-------------------

Dans ce mod?le les agents jouent un seul ?v?nement musical.
Nous pourrions imaginer qu'ils calculent des datas plus compl?xes....


NETLOGO FEATURES
----------------
This section could point out any especially interesting or unusual features of NetLogo that the model makes use of, particularly in the Procedures tab.  It might also point out places where workarounds were needed because of missing features.


RELATED MODELS
--------------

Musique Multi-Agents


CREDITS AND REFERENCES
----------------------

http://membres.lycos.fr/herveprovini/

You can use this without restriction
@#$#@#$#@
default
true
0
Polygon -7500403 true true 150 5 40 250 150 205 260 250

airplane
true
0
Polygon -7500403 true true 150 0 135 15 120 60 120 105 15 165 15 195 120 180 135 240 105 270 120 285 150 270 180 285 210 270 165 240 180 180 285 195 285 165 180 105 180 60 165 15

arrow
true
0
Polygon -7500403 true true 150 0 0 150 105 150 105 293 195 293 195 150 300 150

box
false
0
Polygon -7500403 true true 150 285 285 225 285 75 150 135
Polygon -7500403 true true 150 135 15 75 150 15 285 75
Polygon -7500403 true true 15 75 15 225 150 285 150 135
Line -16777216 false 150 285 150 135
Line -16777216 false 150 135 15 75
Line -16777216 false 150 135 285 75

bug
true
0
Circle -7500403 true true 96 182 108
Circle -7500403 true true 110 127 80
Circle -7500403 true true 110 75 80
Line -7500403 true 150 100 80 30
Line -7500403 true 150 100 220 30

butterfly
true
0
Polygon -7500403 true true 150 165 209 199 225 225 225 255 195 270 165 255 150 240
Polygon -7500403 true true 150 165 89 198 75 225 75 255 105 270 135 255 150 240
Polygon -7500403 true true 139 148 100 105 55 90 25 90 10 105 10 135 25 180 40 195 85 194 139 163
Polygon -7500403 true true 162 150 200 105 245 90 275 90 290 105 290 135 275 180 260 195 215 195 162 165
Polygon -16777216 true false 150 255 135 225 120 150 135 120 150 105 165 120 180 150 165 225
Circle -16777216 true false 135 90 30
Line -16777216 false 150 105 195 60
Line -16777216 false 150 105 105 60

car
false
0
Polygon -7500403 true true 300 180 279 164 261 144 240 135 226 132 213 106 203 84 185 63 159 50 135 50 75 60 0 150 0 165 0 225 300 225 300 180
Circle -16777216 true false 180 180 90
Circle -16777216 true false 30 180 90
Polygon -16777216 true false 162 80 132 78 134 135 209 135 194 105 189 96 180 89
Circle -7500403 true true 47 195 58
Circle -7500403 true true 195 195 58

circle
false
0
Circle -7500403 true true 0 0 300

circle 2
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240

cow
false
0
Polygon -7500403 true true 200 193 197 249 179 249 177 196 166 187 140 189 93 191 78 179 72 211 49 209 48 181 37 149 25 120 25 89 45 72 103 84 179 75 198 76 252 64 272 81 293 103 285 121 255 121 242 118 224 167
Polygon -7500403 true true 73 210 86 251 62 249 48 208
Polygon -7500403 true true 25 114 16 195 9 204 23 213 25 200 39 123

cylinder
false
0
Circle -7500403 true true 0 0 300

dot
false
0
Circle -7500403 true true 90 90 120

face happy
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 255 90 239 62 213 47 191 67 179 90 203 109 218 150 225 192 218 210 203 227 181 251 194 236 217 212 240

face neutral
false
0
Circle -7500403 true true 8 7 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Rectangle -16777216 true false 60 195 240 225

face sad
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 168 90 184 62 210 47 232 67 244 90 220 109 205 150 198 192 205 210 220 227 242 251 229 236 206 212 183

fish
false
0
Polygon -1 true false 44 131 21 87 15 86 0 120 15 150 0 180 13 214 20 212 45 166
Polygon -1 true false 135 195 119 235 95 218 76 210 46 204 60 165
Polygon -1 true false 75 45 83 77 71 103 86 114 166 78 135 60
Polygon -7500403 true true 30 136 151 77 226 81 280 119 292 146 292 160 287 170 270 195 195 210 151 212 30 166
Circle -16777216 true false 215 106 30

flag
false
0
Rectangle -7500403 true true 60 15 75 300
Polygon -7500403 true true 90 150 270 90 90 30
Line -7500403 true 75 135 90 135
Line -7500403 true 75 45 90 45

flower
false
0
Polygon -10899396 true false 135 120 165 165 180 210 180 240 150 300 165 300 195 240 195 195 165 135
Circle -7500403 true true 85 132 38
Circle -7500403 true true 130 147 38
Circle -7500403 true true 192 85 38
Circle -7500403 true true 85 40 38
Circle -7500403 true true 177 40 38
Circle -7500403 true true 177 132 38
Circle -7500403 true true 70 85 38
Circle -7500403 true true 130 25 38
Circle -7500403 true true 96 51 108
Circle -16777216 true false 113 68 74
Polygon -10899396 true false 189 233 219 188 249 173 279 188 234 218
Polygon -10899396 true false 180 255 150 210 105 210 75 240 135 240

house
false
0
Rectangle -7500403 true true 45 120 255 285
Rectangle -16777216 true false 120 210 180 285
Polygon -7500403 true true 15 120 150 15 285 120
Line -16777216 false 30 120 270 120

leaf
false
0
Polygon -7500403 true true 150 210 135 195 120 210 60 210 30 195 60 180 60 165 15 135 30 120 15 105 40 104 45 90 60 90 90 105 105 120 120 120 105 60 120 60 135 30 150 15 165 30 180 60 195 60 180 120 195 120 210 105 240 90 255 90 263 104 285 105 270 120 285 135 240 165 240 180 270 195 240 210 180 210 165 195
Polygon -7500403 true true 135 195 135 240 120 255 105 255 105 285 135 285 165 240 165 195

line
true
0
Line -7500403 true 150 0 150 300

line half
true
0
Line -7500403 true 150 0 150 150

link
true
0
Line -7500403 true 150 0 150 300

link direction
true
0
Line -7500403 true 150 150 30 225
Line -7500403 true 150 150 270 225

pentagon
false
0
Polygon -7500403 true true 150 15 15 120 60 285 240 285 285 120

person
false
0
Circle -7500403 true true 110 5 80
Polygon -7500403 true true 105 90 120 195 90 285 105 300 135 300 150 225 165 300 195 300 210 285 180 195 195 90
Rectangle -7500403 true true 127 79 172 94
Polygon -7500403 true true 195 90 240 150 225 180 165 105
Polygon -7500403 true true 105 90 60 150 75 180 135 105

plant
false
0
Rectangle -7500403 true true 135 90 165 300
Polygon -7500403 true true 135 255 90 210 45 195 75 255 135 285
Polygon -7500403 true true 165 255 210 210 255 195 225 255 165 285
Polygon -7500403 true true 135 180 90 135 45 120 75 180 135 210
Polygon -7500403 true true 165 180 165 210 225 180 255 120 210 135
Polygon -7500403 true true 135 105 90 60 45 45 75 105 135 135
Polygon -7500403 true true 165 105 165 135 225 105 255 45 210 60
Polygon -7500403 true true 135 90 120 45 150 15 180 45 165 90

square
false
0
Rectangle -7500403 true true 30 30 270 270

square 2
false
0
Rectangle -7500403 true true 30 30 270 270
Rectangle -16777216 true false 60 60 240 240

star
false
0
Polygon -7500403 true true 151 1 185 108 298 108 207 175 242 282 151 216 59 282 94 175 3 108 116 108

target
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240
Circle -7500403 true true 60 60 180
Circle -16777216 true false 90 90 120
Circle -7500403 true true 120 120 60

tree
false
0
Circle -7500403 true true 118 3 94
Rectangle -6459832 true false 120 195 180 300
Circle -7500403 true true 65 21 108
Circle -7500403 true true 116 41 127
Circle -7500403 true true 45 90 120
Circle -7500403 true true 104 74 152

triangle
false
0
Polygon -7500403 true true 150 30 15 255 285 255

triangle 2
false
0
Polygon -7500403 true true 150 30 15 255 285 255
Polygon -16777216 true false 151 99 225 223 75 224

truck
false
0
Rectangle -7500403 true true 4 45 195 187
Polygon -7500403 true true 296 193 296 150 259 134 244 104 208 104 207 194
Rectangle -1 true false 195 60 195 105
Polygon -16777216 true false 238 112 252 141 219 141 218 112
Circle -16777216 true false 234 174 42
Rectangle -7500403 true true 181 185 214 194
Circle -16777216 true false 144 174 42
Circle -16777216 true false 24 174 42
Circle -7500403 false true 24 174 42
Circle -7500403 false true 144 174 42
Circle -7500403 false true 234 174 42

turtle
true
0
Polygon -10899396 true false 215 204 240 233 246 254 228 266 215 252 193 210
Polygon -10899396 true false 195 90 225 75 245 75 260 89 269 108 261 124 240 105 225 105 210 105
Polygon -10899396 true false 105 90 75 75 55 75 40 89 31 108 39 124 60 105 75 105 90 105
Polygon -10899396 true false 132 85 134 64 107 51 108 17 150 2 192 18 192 52 169 65 172 87
Polygon -10899396 true false 85 204 60 233 54 254 72 266 85 252 107 210
Polygon -7500403 true true 119 75 179 75 209 101 224 135 220 225 175 261 128 261 81 224 74 135 88 99

wheel
false
0
Circle -7500403 true true 3 3 294
Circle -16777216 true false 30 30 240
Line -7500403 true 150 285 150 15
Line -7500403 true 15 150 285 150
Circle -7500403 true true 120 120 60
Line -7500403 true 216 40 79 269
Line -7500403 true 40 84 269 221
Line -7500403 true 40 216 269 79
Line -7500403 true 84 40 221 269

x
false
0
Polygon -7500403 true true 270 75 225 30 30 225 75 270
Polygon -7500403 true true 30 75 75 30 270 225 225 270

@#$#@#$#@
NetLogo 3D Preview 5
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
default
0.0
-0.2 0 0.0 1.0
0.0 1 1.0 0.0
0.2 0 0.0 1.0
link direction
true
0
Line -7500403 true 150 150 90 180
Line -7500403 true 150 150 210 180

@#$#@#$#@
